<?php $__env->startSection('content'); ?>
<?php if($errors->any()): ?>
    <div class="alert alert-danger">
        <ul>
            <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <li><?php echo e($error); ?></li>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </ul>
    </div>
<?php endif; ?>
<div class="card bg-body-white hoverable card-xl-stretch mb-xl-8">	
	<div class="card card-custom">
        <div class="card-header">
            <h3 class="card-title">
                Project Details
            </h3>
            <div class="card-toolbar">
                <div class="example-tools justify-content-center">
                    <span class="example-toggle" data-toggle="tooltip" title="View code"></span>
                    <span class="example-copy" data-toggle="tooltip" title="Copy code"></span>
                </div>
            </div>
        </div>
	    <!--begin::Form-->
        <form action="<?php echo e(isset($project) ? route('admin.projects.update', $project->id) : route('admin.projects.store')); ?>"
        method="POST" enctype="multipart/form-data" class="form">
            <?php echo csrf_field(); ?>
            <?php if(isset($project)): ?>
                <?php echo method_field('PUT'); ?>
            <?php endif; ?>
            <input type="hidden" name="country_id" class="putCountryId">
            <div class="card-body">
              <div class="row">
                <div class="form-group col-md-6">
                    <label>Name</label>
                    <input type="text" name="name" value="<?php echo e(old('name', $project->name ?? '')); ?>"
                        class="form-control form-control-solid" placeholder="" required>
                </div>
                <div class="form-group col-md-6">
                    <label>Release Date</label>
                    <input type="date" name="release_date" value="<?php echo e(old('release_date', $project->release_date ?? '')); ?>"
                        class="form-control form-control-solid" required>
                </div>
                <div class="form-group col-md-6">
                    <label>Writers</label>
                    <input type="text" name="writers" value="<?php echo e(old('writers', $project->writers ?? '')); ?>"
                        class="form-control form-control-solid" placeholder="" >
                </div> 
                <div class="form-group col-md-6">
                    <label>Director</label>
                    <input type="text" name="director" value="<?php echo e(old('director', $project->director ?? '')); ?>"
                        class="form-control form-control-solid" placeholder="" >
                </div> 
                <div class="form-group col-md-6">
                    <label>Producer</label>
                    <input type="text" name="producer" value="<?php echo e(old('producer', $project->producer ?? '')); ?>"
                        class="form-control form-control-solid" placeholder="" >
                </div> 
                <div class="form-group col-md-6">
                    <label>Production House</label>
                    <input type="text" name="production_house" value="<?php echo e(old('production_house', $project->production_house ?? '')); ?>"
                        class="form-control form-control-solid" placeholder="" >
                </div> 
                <div class="form-group col-md-6">
                    <label> Starring</label>
                    <input type="text" name="music_director" value="<?php echo e(old('music_director', $project->music_director ?? '')); ?>"
                        class="form-control form-control-solid" placeholder="" >
                </div> 
                <div class="form-group col-md-6">
                    <label>Music Partner</label>
                    <input type="text" name="music_partner" value="<?php echo e(old('music_partner', $project->music_partner ?? '')); ?>"
                        class="form-control form-control-solid" placeholder="" >
                </div>               
                <div class="form-group col-md-6">
                    <label>Image</label>                    
                    <?php if(!empty($project->image)): ?>
                        <div class="mb-2">
                            <img src="<?php echo e(asset('storage/' . $project->image)); ?>" width="100" height="70">
                        </div>
                    <?php endif; ?>
                    <input type="file" name="image" accept="image/*" class="form-control form-control-solid">
                </div> 
                 <div class="form-group col-md-6">
                    <label>Video</label>                    
                    <?php if(!empty($project->video)): ?>
                        <div class="mb-2">
                            <video width="100" height="50" controls>
                              <source src="<?php echo e(asset('storage/' . $project->video)); ?>" type="video/mp4">
                                 Your browser does not support the video tag.
                            </video>
                        </div>
                    <?php endif; ?>
                    <input type="file" name="video" accept="video/*" class="form-control form-control-solid">
                </div> 
                <div class="form-group col-md-12">
                    <label>Youtube Video Id</label>                    
                    <input type="text" name="youtube_video_id" class="form-control form-control-solid" value="<?php echo e(old('youtube_video_id', $project->youtube_video_id ?? '')); ?>" placeholder="Video Id">
                </div> 
              
                <div class="form-group col-md-5">
                    <label>Status</label>
                    <select name="status" class="form-control form-control-solid" >
                        <option value="1" <?php echo e(old('status', $project->status ?? 1) == 1 ? 'selected' : ''); ?>>Active</option>
                        <option value="0" <?php echo e(old('status', $project->status ?? 1) == 0 ? 'selected' : ''); ?>>Inactive</option>
                    </select>
                </div>
                  <div class="form-group col-md-5">
                        <label class="form-label required">Project Type</label>
                        <select name="type" id="type" class="form-control form-control-solid" required>
                            <option value="bollywood" <?php echo e(old('type', $project->type ?? '') == 'bollywood' ? 'selected' : ''); ?>>Bollywood</option>
                            <option value="hollywood" <?php echo e(old('type', $project->type ?? '') == 'hollywood' ? 'selected' : ''); ?>>Hollywood</option>
                       </select>
                </div> 
                 <div class="form-group col-md-2">
                    <label for="upcoming_projects" class="mb-3"> &nbsp;&nbsp; Upcoming Projects</label>
                    <div class="form-check form-check-sm form-check-custom form-check-solid">
                       <input class="form-check-input border border-primary" type="checkbox" id="upcoming_projects" value="1" name="upcoming_projects" <?php echo e(isset($project->upcoming_projects) && $project->upcoming_projects ? 'checked' : ''); ?>>

                    </div>        
                </div>
                 <div class="form-group col-md-12">
                    <label>Short Description</label>
                    <textarea name="short_description" class="form-control form-control-solid editor" ><?php echo e(old('short_description', $project->short_description ?? '')); ?></textarea>
                </div>        
                 <div class="form-group col-md-12">
                    <label>Description</label>
                    <textarea name="description" class="form-control form-control-solid editor" ><?php echo e(old('description', $project->description ?? '')); ?></textarea>
                </div>
              </div>
            </div>

            <div class="card-footer">
                <button type="submit" class="btn btn-primary mr-2"><?php echo e(isset($project) ? 'Update' : 'Save'); ?></button>
                <a href="<?php echo e(route('admin.projects.index')); ?>" class="btn btn-secondary">Cancel</a>
            </div>
        </form>
	    <!--end::Form-->
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('admin.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/content_engineers/resources/views/admin/projects/form.blade.php ENDPATH**/ ?>