<?php $__env->startSection('content'); ?>
<div class="card bg-body-white hoverable card-xl-stretch mb-xl-8">	
	<div class="card card-custom">
		<div class="card-header">
			<h3 class="card-title">
				Enquiry List
			</h3>
		</div>
        <div class="card-header border-0 pt-6" data-select2-id="select2-data-82-td10">
			<div class="card-title">
				<div class="d-flex align-items-center position-relative my-1">
					<span class="svg-icon svg-icon-1 position-absolute ms-6">
						<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none">
							<rect opacity="0.5" x="17.0365" y="15.1223" width="8.15546" height="2" rx="1" transform="rotate(45 17.0365 15.1223)" fill="black"></rect>
							<path d="M11 19C6.55556 19 3 15.4444 3 11C3 6.55556 6.55556 3 11 3C15.4444 3 19 6.55556 19 11C19 15.4444 15.4444 19 11 19ZM11 5C7.53333 5 5 7.53333 5 11C5 14.4667 7.53333 17 11 17C14.4667 17 17 14.4667 17 11C17 7.53333 14.4667 5 11 5Z" fill="black"></path>
						</svg>
					</span>
					<input type="text" data-kt-user-table-filter="search" class="form-control form-control-solid w-250px ps-14" placeholder="Search user">
				</div>
				
			</div>
			</div>
		</div>
		<div class="card-body pt-0">
			<div class="table-responsive">
				<table class="table align-middle table-row-dashed fs-6 gy-5 dataTable no-footer" id="kt_table_users">
			        <thead>
			            <tr>
			                <th>#</th>
			                <th>Name</th>
			                <th>Email</th>
			                <th>Phone</th>
			                <th>Message</th>
			                <th>Date</th>
			            </tr>
			        </thead>
			        <tbody>
			            <?php $__currentLoopData = $enquiries; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $i => $enquiry): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
			                <tr>
			                    <td><?php echo e($i+1); ?></td>
			                    <td><?php echo e(ucfirst($enquiry->name)); ?></td>
			                    <td><?php echo e($enquiry->email); ?></td>
			                    <td><?php echo e($enquiry->phone); ?></td>
			                    <td>
								    <?php echo e(\Str::limit($enquiry->message, 30)); ?>

								    <?php if(strlen($enquiry->message) > 30): ?>
								        <a href="#" data-bs-toggle="modal" data-bs-target="#enquiryModal<?php echo e($enquiry->id); ?>">Read More</a>
								    <?php endif; ?>
								</td>
			                    <td><?php echo e($enquiry->created_at->format('Y-m-d H:i')); ?></td>
			                </tr>
							<div class="modal fade" id="enquiryModal<?php echo e($enquiry->id); ?>" tabindex="-1" aria-labelledby="enquiryModalLabel<?php echo e($enquiry->id); ?>" aria-hidden="true">
							  <div class="modal-dialog">
							    <div class="modal-content">
							      <div class="modal-header">
							        <h5 class="modal-title" id="enquiryModalLabel<?php echo e($enquiry->id); ?>">Message </h5>
							        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
							      </div>
							      <div class="modal-body">
							        <?php echo e($enquiry->message); ?>

							      </div>
							    </div>
							  </div>
							</div>

			            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
			        </tbody>
			    </table>
			</div>
		</div>
	</div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('admin.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/content_engineers/resources/views/admin/enquiry.blade.php ENDPATH**/ ?>