<!doctype html>
<html lang="en">
  <head>
    <!-- Required meta tags -->
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <link rel="icon" type="image/x-icon" href="<?php echo e(asset('/assets/front/images/favicon.svg')); ?>"> 
    <!-- Bootstrap CSS -->
    <link rel="stylesheet" href="<?php echo e(asset('/assets/front/css/bootstrap.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('/assets/front/css/all.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('/assets/front/css/slick.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('/assets/front/css/animate.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('/assets/front/css/custom.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('/assets/front/css/responsive.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('/assets/front/css/timeline.css')); ?>">
    <title>Content Engineer</title>
    <script> var baseUrl = "<?php echo e(url('/')); ?>";  </script>
    <script src="<?php echo e(asset('/assets/front/js/jquery-3.7.0.min.js')); ?>" ></script>
  </head>
   <?php if(!isset($class) && !isset($header_logo)): ?>
    <?php
      $class = 'header_inner';
      $header_logo = 'CE-logo.svg';
    ?>
  <?php endif; ?>

<?php
  $headerMenus = getFrontMenuHelper(1);
?>

  <body class="<?php echo e($class); ?>">
    <header class="header_sec">
      <div class="container">
        <div class="row g-0 align-items-center justify-content-between">
          <div class="col-auto">
            <a class="logo_main" href="<?php echo e(route('front.index')); ?>">
              <img src="<?php echo e(asset('/assets/front/images/'. $header_logo)); ?>" alt="">
            </a>
          </div>
          <div class="col-auto order-lg-0 order-1">
            <nav class="navbar navbar-expand-lg navbar-dark ">
              <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarResponsive" aria-controls="navbarResponsive" aria-expanded="false" aria-label="Toggle navigation">
                <span class="navbar-toggler-icon">
                  <span></span>
                  <span></span>
                  <span></span>
                </span>
              </button>

              <div class="collapse navbar-collapse" id="navbarResponsive">
                <ul class="main_menu">
                  <?php $__currentLoopData = $headerMenus; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $menu): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                   <li><a href="<?php echo e(url($menu->link)); ?>"><?php echo e($menu->title); ?></a></li>
                  <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </ul>
              </div>
            </nav>
          </div>
        </div>
      </div>
    </header>
    <div class="header_space"></div>
    <div class="window_full_overlay"></div>

    <?php /**PATH /var/www/html/content_engineers/resources/views/front/layouts/header.blade.php ENDPATH**/ ?>