<?php $__env->startSection('content'); ?>
<?php if($errors->any()): ?>
    <div class="alert alert-danger">
        <ul>
            <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <li><?php echo e($error); ?></li>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </ul>
    </div>
<?php endif; ?>
<div class="card bg-body-white hoverable card-xl-stretch mb-xl-8">	
	<div class="card card-custom">
        <div class="card-header">
            <h3 class="card-title">
                Team Details
            </h3>
            <div class="card-toolbar">
                <div class="example-tools justify-content-center">
                    <span class="example-toggle" data-toggle="tooltip" title="View code"></span>
                    <span class="example-copy" data-toggle="tooltip" title="Copy code"></span>
                </div>
            </div>
        </div>
	    <!--begin::Form-->
        <form action="<?php echo e(isset($member) ? route('admin.teams.update', $member->id) : route('admin.teams.store')); ?>"
        method="POST" enctype="multipart/form-data" class="form">
            <?php echo csrf_field(); ?>
            <?php if(isset($member)): ?>
                <?php echo method_field('PUT'); ?>
            <?php endif; ?>
            <input type="hidden" name="country_id" class="putCountryId">
            <div class="card-body">
                <div class="form-group">
                    <label class="required">Name</label>
                    <input type="text" name="name" value="<?php echo e(old('name', $member->name ?? '')); ?>"
                        class="form-control form-control-solid" placeholder="" required>
                </div>                
                <div class="form-group">
                    <label class="required">Designation</label>
                    <input type="text" name="designation" value="<?php echo e(old('designation', $member->designation ?? '')); ?>"
                        class="form-control form-control-solid" placeholder="" required>
                </div>
                <div class="form-group">
                    <label class="required">Description</label>
                    <textarea name="description" rows="5" class="form-control form-control-solid editor" required><?php echo e(old('description', $member->description ?? '')); ?></textarea>
                </div>
                <div class="form-group">
                    <label>Address</label>
                    <textarea name="address" class="form-control form-control-solid"><?php echo e(old('address', $member->address ?? '')); ?></textarea>
                </div>
                <div class="form-group">
                    <label>Image</label>                    
                    <?php if(!empty($member->image)): ?>
                        <div class="mb-2">
                            <img src="<?php echo e(asset('storage/' . $member->image)); ?>" width="100">
                        </div>
                    <?php endif; ?>
                    <input type="file" name="image" accept="image/*" class="form-control form-control-solid">
                </div>
                <div class="form-group">
                    <label class="required">Status</label>
                    <select name="status" class="form-control form-control-solid" required>
                        <option value="1" <?php echo e(old('status', $member->status ?? 1) == 1 ? 'selected' : ''); ?>>Active</option>
                        <option value="0" <?php echo e(old('status', $member->status ?? 1) == 0 ? 'selected' : ''); ?>>Inactive</option>
                    </select>
                </div>
            </div>

            <div class="card-footer">
                <button type="submit" class="btn btn-primary mr-2"><?php echo e(isset($member) ? 'Update' : 'Save'); ?></button>
                <a href="<?php echo e(route('admin.teams.index')); ?>" class="btn btn-secondary">Cancel</a>
            </div>
        </form>
	    <!--end::Form-->
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('admin.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/content_engineers/resources/views/admin/teams/form.blade.php ENDPATH**/ ?>