<?php $__env->startSection('content'); ?>
<?php if($errors->any()): ?>
    <div class="alert alert-danger">
        <ul>
            <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <li><?php echo e($error); ?></li>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </ul>
    </div>
<?php endif; ?>
<div class="card bg-body-white hoverable card-xl-stretch mb-xl-8">	
	<div class="card card-custom">
        <div class="card-header">
            <h3 class="card-title">
                Category Details
            </h3>
            <div class="card-toolbar">
                <div class="example-tools justify-content-center">
                    <span class="example-toggle" data-toggle="tooltip" title="View code"></span>
                    <span class="example-copy" data-toggle="tooltip" title="Copy code"></span>
                </div>
            </div>
        </div>
	    <!--begin::Form-->
        <form action="<?php echo e(isset($category) ? route('admin.categories.update', $category->id) : route('admin.categories.store')); ?>"
        method="POST" enctype="multipart/form-data" class="form">
            <?php echo csrf_field(); ?>
            <?php if(isset($category)): ?>
                <?php echo method_field('PUT'); ?>
            <?php endif; ?>
            <input type="hidden" name="country_id" class="putCountryId">
            <div class="card-body">
                <div class="form-group">
                    <label>Name</label>
                    <input type="text" name="name" value="<?php echo e(old('name', $category->name ?? '')); ?>"
                      onblur="slugify(this.value);"  class="form-control form-control-solid" placeholder="" required>
                </div>                
                <div class="form-group">
                    <label>Slug</label>
                    <input type="text" name="slug" value="<?php echo e(old('slug', $category->slug ?? '')); ?>"
                        class="form-control form-control-solid" placeholder="" id="slug" required>
                </div>
                <div class="form-group">
                    <label>Short Description</label>
                    <textarea name="short_desc" class="form-control form-control-solid" required><?php echo e(old('short_desc', $category->short_desc ?? '')); ?></textarea>
                </div>
                <div class="form-group">
                    <label>Long Description</label>
                    <textarea name="long_desc" class="form-control form-control-solid" required><?php echo e(old('long_desc', $category->long_desc ?? '')); ?></textarea>
                </div>
                <div class="form-group">
                    <label>Image</label>                    
                    <?php if(!empty($category->image)): ?>
                        <div class="mb-2">
                            <img src="<?php echo e(asset('storage/' . $category->image)); ?>" width="100">
                        </div>
                    <?php endif; ?>
                    <input type="file" name="image" accept="image/*" class="form-control form-control-solid">
                </div>
                <div class="form-group">
                    <label>Status</label>
                    <select name="status" class="form-control form-control-solid" required>
                        <option value="1" <?php echo e(old('status', $category->status ?? 1) == 1 ? 'selected' : ''); ?>>Active</option>
                        <option value="0" <?php echo e(old('status', $category->status ?? 1) == 0 ? 'selected' : ''); ?>>Inactive</option>
                    </select>
                </div>
            </div>

            <div class="card-footer">
                <button type="submit" class="btn btn-primary mr-2"><?php echo e(isset($category) ? 'Update' : 'Save'); ?></button>
                <a href="<?php echo e(route('admin.categories.index')); ?>" class="btn btn-secondary">Cancel</a>
            </div>
        </form>
	    <!--end::Form-->
    </div>
</div>
<script>
function slugify(title) {
  // 1. Convert to lowercase and trim whitespace
  let slug = title.toLowerCase().trim();

  // 2. Replace spaces with hyphens
  slug = slug.replace(/\s+/g, '-');

  // 3. Remove special characters (keep alphanumeric and hyphens)
  slug = slug.replace(/[^a-z0-9-]/g, '');

  // 4. Replace multiple hyphens with a single hyphen
  slug = slug.replace(/-+/g, '-');

  // 5. Remove leading/trailing hyphens (if any remain)
  slug = slug.replace(/^-+|-+$/g, '');

  $("#slug").val(slug);
}
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('admin.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/content_engineers/resources/views/admin/categories/form.blade.php ENDPATH**/ ?>