<?php $__env->startSection('content'); ?>
<?php if($errors->any()): ?>
    <div class="alert alert-danger">
        <ul>
            <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <li><?php echo e($error); ?></li>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </ul>
    </div>
<?php endif; ?>
<div class="card bg-body-white hoverable card-xl-stretch mb-xl-8">	
	<div class="card card-custom">
        <div class="card-header">
            <h3 class="card-title">
                Blog Details
            </h3>
            <div class="card-toolbar">
                <div class="example-tools justify-content-center">
                    <span class="example-toggle" data-toggle="tooltip" title="View code"></span>
                    <span class="example-copy" data-toggle="tooltip" title="Copy code"></span>
                </div>
            </div>
        </div>
	    <!--begin::Form-->
        <form action="<?php echo e(isset($blog) ? route('admin.blogs.update', $blog->id) : route('admin.blogs.store')); ?>"
        method="POST" enctype="multipart/form-data" class="form">
            <?php echo csrf_field(); ?>
            <?php if(isset($blog)): ?>
                <?php echo method_field('PUT'); ?>
            <?php endif; ?>
            <input type="hidden" name="country_id" class="putCountryId">
            <div class="card-body">
                <div class="row">
                    <div class="form-group col-md-12">
                        <label>Title</label>
                        <textarea name="title" class="form-control form-control-solid editor" required><?php echo e(old('title', $blog->title ?? '')); ?></textarea>
                    </div>

                    <div class="form-group col-md-6">
                        <label>Read More Link</label>
                        <input type="text" name="redirect_link" class="form-control form-control-solid" required value="<?php echo e(old('redirect_link', $blog->redirect_link ?? '')); ?>">
                    </div>
                    <div class="form-group col-md-6">
                        <label class="form-label d-block">Tags</label>
                        <input id="kt_ecommerce_add_product_tags" name="tags" class="form-control mb-2" value="<?php echo e(old('tags', $blog->tags ?? '')); ?>">
                    </div>
                    <div class="form-group col-md-6">
                        <label>Category</label>
                        <select name="category" class="form-control form-control-solid" required>
                        <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($category->id); ?>" <?php echo e(old('category', $blog->category ?? 1) ==  $category->id ? 'selected' : ''); ?>><?php echo e($category->name); ?></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>                    
                        </select>
                    </div>
                    <div class="form-group col-md-6">
                        <label>Status</label>
                        <select name="status" class="form-control form-control-solid" required>
                            <option value="1" <?php echo e(old('status', $blog->status ?? 1) == 1 ? 'selected' : ''); ?>>Active</option>
                            <option value="0" <?php echo e(old('status', $blog->status ?? 1) == 0 ? 'selected' : ''); ?>>Inactive</option>
                        </select>
                    </div>
                    <div class="form-group col-md-12">
                        <label>Image</label>
                        <?php if(!empty($blog->image)): ?>
                            <div class="mb-2">
                                <img src="<?php echo e(asset('storage/' . $blog->image)); ?>" width="100">
                            </div>
                        <?php endif; ?>
                        <input type="file" name="image" accept="image/*" class="form-control form-control-solid">
                    </div>
                    <div class="form-group col-md-12">
                        <label>Description</label>
                        <textarea name="description" class="form-control form-control-solid editor" rows="5" required><?php echo e(old('description', $blog->description ?? '')); ?></textarea>
                    </div>                
                </div>                
            </div>

            <div class="card-footer">
                <button type="submit" class="btn btn-primary mr-2"><?php echo e(isset($blog) ? 'Update' : 'Save'); ?></button>
                <a href="<?php echo e(route('admin.blogs.index')); ?>" class="btn btn-secondary">Cancel</a>
            </div>
        </form>
	    <!--end::Form-->
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('admin.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/content_engineers/resources/views/admin/blogs/form.blade.php ENDPATH**/ ?>