<?php $__env->startSection('content'); ?>
<?php if($errors->any()): ?>
    <div class="alert alert-danger">
        <ul>
            <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <li><?php echo e($error); ?></li>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </ul>
    </div>
<?php endif; ?>
<div class="card bg-body-white hoverable card-xl-stretch mb-xl-8">	
	<div class="card card-custom">
        <div class="card-header">
            <h3 class="card-title">
                Video Details
            </h3>
            <div class="card-toolbar">
                <div class="example-tools justify-content-center">
                    <span class="example-toggle" data-toggle="tooltip" title="View code"></span>
                    <span class="example-copy" data-toggle="tooltip" title="Copy code"></span>
                </div>
            </div>
        </div>
	    <!--begin::Form-->
        <form action="<?php echo e(isset($video) ? route('admin.videos.update', $video->id) : route('admin.videos.store')); ?>"
        method="POST" enctype="multipart/form-data" class="form">
            <?php echo csrf_field(); ?>
            <?php if(isset($video)): ?>
                <?php echo method_field('PUT'); ?>
            <?php endif; ?>
            <input type="hidden" name="country_id" class="putCountryId">
            <div class="card-body">
                <div class="form-group">
                    <label>Title</label>
                    <input type="text" name="title" value="<?php echo e(old('title', $video->title ?? '')); ?>"
                        class="form-control form-control-solid" placeholder="" required>
                </div>
                <div class="form-group">
                    <label>Section</label>
                    <input type="text" name="section" value="<?php echo e(old('section', $video->section ?? '')); ?>"
                        class="form-control form-control-solid" placeholder="" required>
                </div>
                <div class="form-group">
                <label>Video</label>                    
                    <?php if(!empty($video->video_file)): ?>
                        <div class="mb-2">
                            <video width="320" controls>
                                <source src="<?php echo e(asset('storage/' . $video->video_file)); ?>" type="video/mp4">
                                Your browser does not support the video tag.
                            </video>
                        </div>
                    <?php endif; ?>
                    <input type="file" name="video_file" accept="video/*" class="form-control form-control-solid">
                </div>               
                <div class="form-group">
                    <label>Status</label>
                    <select name="status" class="form-control form-control-solid" required>
                        <option value="1" <?php echo e(old('status', $video->status ?? 1) == 1 ? 'selected' : ''); ?>>Active</option>
                        <option value="0" <?php echo e(old('status', $video->status ?? 1) == 0 ? 'selected' : ''); ?>>Inactive</option>
                    </select>
                </div>
            </div>

            <div class="card-footer">
                <button type="submit" class="btn btn-primary mr-2"><?php echo e(isset($video) ? 'Update' : 'Save'); ?></button>
                <a href="<?php echo e(route('admin.videos.index')); ?>" class="btn btn-secondary">Cancel</a>
            </div>
        </form>
	    <!--end::Form-->
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('admin.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/content_engineers/resources/views/admin/videos/form.blade.php ENDPATH**/ ?>